#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_S 200005

int N, Q;
int A[MAX_S];
int C[MAX_S]; 

long long BC[MAX_S]; 
long long BS[MAX_S]; 

long long UkupnaSumaS = 0; 

void BIT_azuriraj(long long *BIT, int idx, long long delta) {
    for (; idx <= N; idx += idx & (-idx)) {
        BIT[idx] += delta;
    }
}

long long BIT_upit(long long *BIT, int idx) {
    long long suma = 0;
    for (; idx > 0; idx -= idx & (-idx)) {
        suma += BIT[idx];
    }
    return suma;
}

int nadji_k_ti(int k) {
    int l = 1, r = N, ans = N;
    while (l <= r) {
        int mid = l + (r - l) / 2;
        if (BIT_upit(BC, mid) >= k) {
            ans = mid;
            r = mid - 1;
        } else {
            l = mid + 1;
        }
    }
    return ans;
}

void AzurirajBIT(int v, int promena_parnosti) {
    if (promena_parnosti == 1) {
        BIT_azuriraj(BC, v, 1);
        BIT_azuriraj(BS, v, v);
    } else {
        BIT_azuriraj(BC, v, -1);
        BIT_azuriraj(BS, v, -v);
    }
}

void Izmeni(int x, int y) {
    int sV = A[x];
    int nV = y;

    if (sV == nV) return;

    if (C[sV] % 2 != 0) AzurirajBIT(sV, -1);
    
    C[sV]--;
    
    if (C[sV] % 2 != 0) AzurirajBIT(sV, 1);

    if (C[nV] % 2 != 0) AzurirajBIT(nV, -1);
    
    C[nV]++;

    if (C[nV] % 2 != 0) AzurirajBIT(nV, 1);

    UkupnaSumaS = UkupnaSumaS - sV + nV;
    A[x] = y;
}

void Odgovor(int k) {
    long long P_potrebno = (long long)N - k; 
    long long N_parovi = (UkupnaSumaS - BIT_upit(BS, N)) / 2; 
    long long S_min;

    long long N_neparan = BIT_upit(BC, N); 

    if (N_parovi >= P_potrebno) {
        S_min = BIT_upit(BS, N);
    } else {
        long long Delta = P_potrebno - N_parovi; 
        
        if (Delta >= N_neparan) {
            S_min = 0;
        } else {
            int K_najmanjih = N_neparan - Delta;
            
            int v_max = nadji_k_ti(K_najmanjih);
            
            S_min = BIT_upit(BS, v_max); 
        }
    }
    printf("%lld\n", S_min);
}

int main() {
    if (scanf("%d %d", &N, &Q) != 2) return 1;

    for (int i = 1; i <= N; i++) {
        if (scanf("%d", &A[i]) != 1) return 1;
        C[A[i]]++;
        UkupnaSumaS += A[i];
    }

    for (int v = 1; v <= N; v++) {
        if (C[v] % 2 != 0) {
            AzurirajBIT(v, 1);
        }
    }

    for (int i = 0; i < Q; i++) {
        int t;
        if (scanf("%d", &t) != 1) return 1;

        if (t == 1) {
            int k; 
            if (scanf("%d", &k) != 1) return 1;
            Odgovor(k);

        } else if (t == 2) {
            int x, y;
            if (scanf("%d %d", &x, &y) != 2) return 1;
            Izmeni(x, y);
        }
    }

    return 0;
}